'use strict'

entityRegistry['module']['texts'] = {
    extendedInfo: {
        displayName: 'Texts',
        displayGroup: '2D Effects',
    },
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'image', displayName: 'Image', type: 'colorTexture', defaultValue: ''},
        { paramName: 'alpha', displayName: 'Alpha', type: 'float', defaultValue: 1},
        { paramName: 'offset', displayName: 'Offset', type: 'float', defaultValue: 0},
        { paramName: 'seed', displayName: 'Seed', type: 'string', defaultValue: 'seed', triggerInit: true },
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                image,
                alpha,
                offset,
                seed,
            } = { ...config }

            const srcHeight = image.height
            const srcImage = image.data
            const dstImage = renderer.canvasBuffer.data

            const yOffset = 0
            const rowOffsets = []
            const rng = new Math.seedrandom(seed)
            for (let i = 0; i < 20; ++i) {
                rowOffsets.push(rng() * 2 - 1)
            }

            for (let y = 0; y < 480; ++y) {
                const rowIndex = Math.floor((y + yOffset) / srcHeight)
                const rpwAlpha = Math.max(0, alpha * (1.2 - rowIndex*.1))
                const xOffset = 640*2 + Math.floor(rowOffsets[rowIndex]*offset)
                let dst = 0 + (y*640)*4
                for (let x = 0; x < 640; x++) {
                    let src = ((x + xOffset)%640 + (((y+yOffset)%srcHeight)*640))*4
                    const a = srcImage[src+3] / 255 * rpwAlpha

                    dstImage[dst] = lerp(dstImage[dst], srcImage[src++], a); dst++
                    dstImage[dst] = lerp(dstImage[dst], srcImage[src++], a); dst++
                    dstImage[dst] = lerp(dstImage[dst], srcImage[src++], a); dst++

                    dst++
                }
            }
        }
    }
}
